// priority: 100

// let 生物强化全局配置 = {};
// 这行代码通常位于配置文件的最顶部（或在所有具体配置赋值之前）。
// 它初始化一个全局对象，后续所有的配置项都将作为这个对象的属性进行添加。
// 如果您将此文件拆分为多个小文件加载，请确保此初始化仅在主配置文件或最先加载的文件中执行一次。

// 1. 难度级别 (例如：EASY, CLASSIC, MYTHIC):
//    - 生物的基础属性和装备掉落概率会根据当前生效的难度级别进行调整。
//    - 难度级别可以通过玩家完成特定进度（见“进度到阶段映射”）或服务器指令（如果您的核心脚本支持）来设定。
//
// 2. 动态阶段 (例如：LV0, LV1, ..., LV9):
//    - 动态阶段允许生物的强化程度随着玩家群体游戏进度的推进而变化。
//    - 当玩家完成特定游戏内进度时，会被赋予相应的动态阶段。
//    - 生物的属性和装备会受到当前“最领先”玩家（根据“动态阶段优先级”）所处动态阶段的影响。
//    - 动态阶段的效果会与难度级别的效果进行叠加（通常是乘算）。
//
// 3. 物品池:
//    - 用于定义在不同情况下（如不同难度、特定生物定制）生物可能获得的装备。
//    - 支持复杂的物品定义，包括多种基础物品、多种附魔组合以及它们的出现权重。
//
// 4. 配置键名约定 (重要!):
//    - 本配置文件及核心强化脚本中，许多由我们自定义的键名（变量名、对象属性名）都使用了中文。
//    - Minecraft 原生的物品ID (如 "minecraft:diamond_sword")、附魔ID (如 "minecraft:sharpness")、
//      属性ID (如 "minecraft:generic.max_health") 以及NBT标签键名 (如 "Damage", "Enchantments", "display") 必须保持英文。
//    - 请确保您在填写配置时，中文键名与核心脚本中引用的完全一致。

let 生物强化全局配置 = {};

//   用途: 定义当玩家完成某个Minecraft原版或模组进度时，应被赋予哪个动态阶段。
//   结构:
//     - 键 (字符串): Minecraft进度的ID (例如 "minecraft:story/mine_diamond")。
//     - 值 (字符串): 对应的动态阶段名称 (例如 "LV1")。此名称应与“动态阶段优先级”和“动态阶段强化效果”中的阶段名一致。
//   示例: 完成“获得钻石”进度后，玩家获得 "LV1" 阶段。
//   注意: 核心脚本(另一个脚本)中的 PlayerEvents.advancement 事件会监听玩家进度完成，并根据此映射更新玩家阶段。

let 进度到阶段映射 = {
  "minecraft:story/root": "LV0",                                        // 玩家加入游戏
  "minecraft:adventure/kill_a_mob": "LV1",                              // 击杀怪物
  "deeperdarker:main/kill_warden": "LV2",                               // 击杀监守者
  "bosses_of_mass_destruction:adventure/void_blossom_defeat ": "LV3",   // 击杀虚空之花
  "mowziesmobs:mowziesmobs/kill_ferrous_wroughtnaut ": "LV4",           // 击杀钢铁守护者
  "goety:goety/kill_a_vizier": "LV5",                                   // 击杀宰相
  "cataclysm:kill_ignis": "LV6",                                        // 击杀焰魔  
  "twilightforest:progress_glacier": "LV7",                             // 击杀冰雪女王
  "minecraft:end/kill_dragon": "LV8",                                   // 击杀末影龙
  "cataclysm:cataclysm/kill_all_bosses": "LV9",                         // 击杀所有灾变boss            
};

//   用途: 定义动态阶段的优先顺序。当附近有多个玩家处于不同动态阶段时，脚本会取优先级最高的阶段作为当前生效的动态阶段。
//   结构:
//     - 数组 (Array)，元素为字符串。
//     - 数组中的阶段名称应从高优先级到低优先级排列。
//     - 这些阶段名称必须与“进度到阶段映射”中的值以及“动态阶段强化效果”中的键名完全一致。
//   示例: "LV9" 的优先级高于 "LV8"，以此类推。

let 动态阶段优先级 = [ // 从高到低
  "LV9", "LV8", "LV7", "LV6", "LV5", "LV4", "LV3", "LV2", "LV1", "LV0",
];

//   用途: 定义在不同游戏难度下，生物各项属性的基础乘数。
//   结构:
//     - 对象 (Object)。
//     - 键 (字符串): 难度标识符 (例如 "EASY", "CLASSIC", "MYTHIC")。这些标识符应与“默认难度”和“难度优先级”中的值一致。
//     - 值 (对象): 该难度下各属性的乘数。
//       - 键 (中文字符串): 属性的中文名称 (例如 "生命", "速度", "伤害")。这些中文名必须与核心脚本中“属性名称映射”变量的键完全对应。
//                         您在此处使用了缩写（如“飞行”、“追踪”），请确保核心脚本的“属性名称映射”也使用相同的缩写。
//       - 值 (数字): 该属性的乘数值。1.0代表无变化，大于1增强，小于1削弱。
//   示例: 在CLASSIC难度下，生物生命值是基础值的2倍，速度是1.1倍。

let 难度属性定义 = {
  EASY:    { 生命: 0.8, 速度: 0.8,  护甲: 0.8,  韧性: 0.8,  追踪: 0.8,  攻速: 0.8,  伤害: 0.5,  箭矢速度: 0.95, },
  CLASSIC: { 生命: 1.5, 速度: 1,    护甲: 1,    韧性: 1,    追踪: 1,    攻速: 1,    伤害: 1,    箭矢速度: 1, },
  MASTER:  { 生命: 3,   速度: 1.1,  护甲: 1.1,  韧性: 1.1,  追踪: 1.3,  攻速: 1.3,  伤害: 1.5,  箭矢速度: 1.05, },
  MYTHIC:  { 生命: 5,   速度: 1.3,  护甲: 1.3,  韧性: 1.3,  追踪: 1.5,  攻速: 1.5,  伤害: 2.0,  箭矢速度: 1.1, }
};

//   用途: 定义在不同游戏难度下，生物各个部位装备的基础生成概率。
//   结构:
//     - 对象 (Object)。
//     - 键 (字符串): 难度标识符 (同上)。
//     - 值 (对象): 该难度下各装备部位的基础生成概率。
//       - 键 (中文字符串): 装备部位的中文名称 (例如 "头盔", "胸甲", "裤衩", "靴子", "武器")。这些键名需要与核心脚本中处理装备的逻辑对应。
//       - 值 (数字, 0到1之间): 该部位装备生成的基础概率。例如0.2代表20%的基础概率。
//   注意: 这个基础概率还会受到后续“生物影响白名单”、“生物定制配置”以及动态阶段效果中定义的概率乘数的影响。

let 难度装备基础概率 = {
  EASY:    { 头盔: 0.1, 胸甲: 0.1, 裤衩: 0.1, 靴子: 0.1, 武器: 0.1 },
  CLASSIC: { 头盔: 0.2, 胸甲: 0.2, 裤衩: 0.2, 靴子: 0.2, 武器: 0.2 },
  MASTER:  { 头盔: 0.3, 胸甲: 0.3, 裤衩: 0.3, 靴子: 0.3, 武器: 0.3 },
  MYTHIC:  { 头盔: 0.5, 胸甲: 0.5, 裤衩: 0.5, 靴子: 0.5, 武器: 0.5 }
};

//   用途: 定义每个动态阶段对生物属性和装备生成的具体影响。
//   结构:
//     - 对象 (Object)。
//     - 键 (字符串): 动态阶段名称 (例如 "LV0", "LV1")。必须与“动态阶段优先级”和“进度到阶段映射”中的阶段名一致。
//     - 值 (对象): 该动态阶段的具体效果。
//       - "属性列表" (对象, 可选): 定义此阶段对生物属性的乘数。结构同“难度属性定义”中的属性乘数部分。这些乘数会叠乘在难度乘数之上。
//                                 请确保这里使用的中文属性名（缩写）与核心脚本的“属性名称映射”一致。
//       - "装备基础概率" (对象, 可选): 定义此阶段对装备基础生成概率的调整（通常是覆盖或补充“难度装备基础概率”）。结构同“难度装备基础概率”中的概率部分。
//       - "护甲池" (对象, 可选, 需要核心脚本支持): 定义此阶段下特定难度的护甲池。结构应为： { "难度标识": { "头盔": [物品池条目], "胸甲": [...] } }
//       - "近战武器池" (数组, 可选, 需要核心脚本支持): 定义此阶段下特定难度的近战武器池。结构应为： { "难度标识": [物品池条目] }
//       - "远程武器池" (数组, 可选, 需要核心脚本支持): 定义此阶段下特定难度的远程武器池。结构应为： { "难度标识": [物品池条目] }
//   示例: "LV1" 阶段下，生物生命乘数为0.6，速度为0.8等，并且头盔等部位有额外0.05的装备生成概率（会与难度概率叠加或覆盖，取决于核心脚本逻辑）。

let 动态阶段强化效果 = {
  "LV0": {
    属性列表: { 生命: 0.5, 速度: 0.7, 护甲: 0.1, 韧性: 0.1, 追踪: 0.7, 攻速: 0.2, 魔法伤害: 0.3, 伤害: 0.3,  箭矢速度: 0.85 },
  },
  "LV1": {
    属性列表: { 生命: 0.6, 速度: 0.8, 护甲: 0.2, 韧性: 0.2, 追踪: 0.8, 攻速: 0.6, 魔法伤害: 0.6, 伤害: 0.6,  箭矢速度: 0.9 },
    装备基础概率: { 头盔: 0.05, 胸甲: 0.05, 裤衩: 0.05, 靴子: 0.05 },
  },
  "LV2": {
    属性列表: { 生命: 0.65, 速度: 0.82, 护甲: 0.3, 韧性: 0.3, 追踪: 0.82, 攻速: 0.65, 魔法伤害: 0.65, 伤害: 0.65, 箭矢速度: 0.94 },
    装备基础概率: { 头盔: 0.1, 胸甲: 0.1, 裤衩: 0.1, 靴子: 0.1, 武器: 0.1 },
  },
  "LV3": {
    属性列表: { 生命: 0.7, 速度: 0.84, 护甲: 0.4, 韧性: 0.4, 追踪: 0.84, 攻速: 0.7, 魔法伤害: 0.7, 伤害: 0.7,  箭矢速度: 0.96 },
    装备基础概率: { 头盔: 0.2, 胸甲: 0.2, 裤衩: 0.2, 靴子: 0.2, 武器: 0.2 },
  },
  "LV4": {
    属性列表: { 生命: 0.75, 速度: 0.86, 护甲: 0.5, 韧性: 0.5, 追踪: 0.86, 攻速: 0.75, 魔法伤害: 0.75, 伤害: 0.75, 箭矢速度: 0.98 },
    装备基础概率: { 头盔: 0.3, 胸甲: 0.3, 裤衩: 0.3, 靴子: 0.3, 武器: 0.3 },
  },
  "LV5": {
    属性列表: { 生命: 0.8, 速度: 0.88, 护甲: 0.6, 韧性: 0.6, 追踪: 0.88, 攻速: 0.8, 魔法伤害: 0.8, 伤害: 0.8,  箭矢速度: 1 },
    装备基础概率: { 头盔: 0.4, 胸甲: 0.4, 裤衩: 0.4, 靴子: 0.4, 武器: 0.4 },
  },
  "LV6": {
    属性列表: { 生命: 0.85, 速度: 0.9, 护甲: 0.7, 韧性: 0.7, 追踪: 0.9, 攻速: 0.85, 魔法伤害: 0.85, 伤害: 0.85, 箭矢速度: 0.9 },
    装备基础概率: { 头盔: 0.5, 胸甲: 0.5, 裤衩: 0.5, 靴子: 0.5, 武器: 0.5 },
  },
  "LV7": {
    属性列表: { 生命: 0.9, 速度: 0.92, 护甲: 0.8, 韧性: 0.8, 追踪: 0.92, 攻速: 0.9, 魔法伤害: 0.9, 伤害: 0.9,  箭矢速度: 0.92 },
    装备基础概率: { 头盔: 0.6, 胸甲: 0.6, 裤衩: 0.6, 靴子: 0.6, 武器: 0.6 },
  },
  "LV8": {
    属性列表: { 生命: 0.95, 速度: 0.95, 护甲: 0.9, 韧性: 0.9, 追踪: 0.95, 攻速: 0.95, 魔法伤害: 0.95, 伤害: 0.95, 箭矢速度: 0.95 },
    装备基础概率: { 头盔: 0.8, 胸甲: 0.8, 裤衩: 0.8, 靴子: 0.8, 武器: 0.8 },
  },
  "LV9": {
    属性列表: { 生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1, 箭矢速度: 1 },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  }
};
// 以下所有物品池（难度护甲池、难度近战/远程武器池、定制实体护甲/武器池）都将遵循新的“高级物品池”结构。
// 结构说明：
//   - 每个池子 (例如 "头盔", "近战武器") 是一个【数组 (Array)】。
//   - 数组中的每个元素是一个【对象 (Object)】，代表一种【基础物品定义】。
//   - 每个【基础物品定义】对象包含以下键 (均为中文，除非特别说明)：
//     - "物品ID" (字符串, 必须): 物品的英文注册名 (例如 "minecraft:diamond_sword")。这是Minecraft能识别的ID。
//     - "物品权重" (数字, 可选, 默认为1): 此基础物品在当前池中被选中的相对权重。如果池中有多种不同的物品ID，权重高的更容易被选中。
//     - "物品数量" (数字, 可选, 默认为1): 生成此物品时的数量。
//     - "基础NBT数据" (对象, 可选): 应用于此物品的基础NBT标签。
//         - 其内部的键名 (如 "Damage", "CustomModelData", "display") 必须是【英文】的Minecraft标准NBT键名。
//         - 例如: 基础NBT数据: {"Damage": 50, "HideFlags": 1}
//     - "附魔方案列表" (数组, 必须): 包含一个或多个【附魔方案对象】。至少应包含一个空方案以表示可能无附魔。
//       - 每个【附魔方案对象】包含:
//         - "选择权重" (数字, 可选, 默认为1): 此附魔方案被选中的相对权重。
//         - "附加NBT数据" (对象, 可选): 特定于此附魔方案的NBT标签，会覆盖或补充“基础NBT数据”。
//             - 其内部键名同样必须是【英文】。
//             - 常用于设置自定义名称: 附加NBT数据: { "display": { "Name": ""{\"text\":\"酷炫的剑\",\"color\":\"gold\"}"" } }
//               (注意Name的值是一个包含JSON文本组件的字符串，外层单引号，内部JSON用双引号)
//         - "附魔列表" (数组, 必须): 包含一个或多个【单个附魔配置对象】。如果为空数组 `[]`，则此方案不应用任何附魔。
//           - 每个【单个附魔配置对象】包含:
//             - "附魔ID" (字符串, 必须): 附魔的英文注册名 (例如 "minecraft:sharpness")。
//             - "附魔等级" (数字 或 对象, 必须): 定义附魔的等级。
//               - 固定等级: 直接写数字，例如 `附魔等级: 3` (表示锋利3)
//               - 范围等级: 使用对象 `{ 最小等级: X, 最大等级: Y }`，例如 `附魔等级: { 最小等级: 1, 最大等级: 3 }` (在1到3级之间随机)
//               - 带权重的等级列表: 使用对象 `{ 等级列表: [L1, L2,...], 权重列表: [W1, W2,...] }`
//                 例如: `附魔等级: { 等级列表: [1, 2, 3], 权重列表: [5, 3, 1] }` (等级1权重5，等级2权重3，等级3权重1)
//
// 示例 (一个MYTHIC难度下的头盔池):
// let 难度护甲池.MYTHIC.头盔 = [
//   {
//     物品ID: "minecraft:netherite_helmet",
//     物品权重: 10,
//     附魔方案列表: [
//       {
//         选择权重: 7, // 70%概率应用这个方案
//         附加NBT数据: { "display": { "Name": ""{\"text\":\"神话·不屈之盔\",\"color\":\"dark_purple\"}"" } },
//         附魔列表: [
//           { 附魔ID: "minecraft:protection", 附魔等级: { 等级列表: [4, 5], 权重列表: [8, 2] } }, // 保护3 (80%) 或 保护V (20%)
//           { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 },
//           { 附魔ID: "minecraft:mending", 附魔等级: 1 }
//         ]
//       },
//       {
//         选择权重: 3, // 30%概率应用这个方案 (可能更专注于特定防护)
//         附魔列表: [
//           { 附魔ID: "minecraft:fire_protection", 附魔等级: 4 },
//           { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }
//         ]
//       }
//     ]
//   },
//   {
//     物品ID: "some_mod:epic_helmet", // 另一个模组的头盔
//     物品权重: 3, // 权重较低，较稀有
//     附魔方案列表: [
//       { 选择权重: 1, 附魔列表: [ { 附魔ID: "minecraft:protection", 附魔等级: 5 } ] }
//     ]
//   }
// ];
//
// 请根据以上结构和说明，填充下面的所有物品池。
// 对于您之前配置中仅有物品ID的条目，我会将其转换为新结构，并赋予默认的物品权重1和空的附魔方案。
// 您需要手动为它们添加期望的附魔方案和权重。
//
let 难度护甲池 = {
  EASY: {
    头盔: [{ 物品ID: "minecraft:leather_helmet", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }], // 皮革头盔
    胸甲: [{ 物品ID: "minecraft:leather_chestplate", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }], // 皮革胸甲
    裤衩: [{ 物品ID: "minecraft:leather_leggings", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }], // 皮革护腿
    靴子: [{ 物品ID: "minecraft:leather_boots", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }] // 皮革靴子
  },
  CLASSIC: {
    头盔: [
      { 物品ID: "minecraft:leather_helmet", 物品权重: 2, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 皮革头盔
      { 物品ID: "minecraft:golden_helmet", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 金头盔
      { 物品ID: "minecraft:chainmail_helmet", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 锁链头盔
      { 物品ID: "twilightforest:ironwood_helmet", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] } // 铁木头盔
    ],
    胸甲: [
      { 物品ID: "minecraft:leather_chestplate", 物品权重: 2, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 皮革胸甲
      { 物品ID: "minecraft:golden_chestplate", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 金胸甲
      { 物品ID: "minecraft:chainmail_chestplate", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 锁链胸甲
      { 物品ID: "twilightforest:ironwood_chestplate", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] } // 铁木胸甲
    ],
    裤衩: [
      { 物品ID: "minecraft:leather_leggings", 物品权重: 2, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 皮革护腿
      { 物品ID: "minecraft:golden_leggings", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 金护腿
      { 物品ID: "minecraft:chainmail_leggings", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 锁链护腿
      { 物品ID: "twilightforest:ironwood_leggings", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] } // 铁木护腿
    ],
    靴子: [
      { 物品ID: "goety:dark_boots", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 黑暗之靴
      { 物品ID: "minecraft:leather_boots", 物品权重: 2, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 皮革靴子
      { 物品ID: "minecraft:golden_boots", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 金靴子
      { 物品ID: "minecraft:chainmail_boots", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 锁链靴子
      { 物品ID: "twilightforest:ironwood_boots", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] } // 铁木靴子
    ]
  },
  MASTER: {
    头盔: [
      {
        物品ID: "minecraft:diamond_helmet", 物品权重: 2, 附魔方案列表: [ // 钻石通头盔
          { 选择权重: 7, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }] }, // 保护 2
          { 选择权重: 3, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 1 }] } // 保护 3, 耐久 1
        ]
      },
      {
        物品ID: "l2complements:poseidite_helmet", 物品权重: 1, 附魔方案列表: [ // 海王头盔
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: { 最小等级: 2, 最大等级: 3 } }, { 附魔ID: "minecraft:respiration", 附魔等级: 1 }] } // 保护 2-3, 水下呼吸 1
        ]
      },
      {
        物品ID: "goety:dark_helmet", 物品权重: 1, 附魔方案列表: [ // 黑暗头盔
          { 选择权重: 8, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }] }, // 保护 2
          { 选择权重: 2, 附魔列表: [{ 附魔ID: "minecraft:projectile_protection", 附魔等级: 3 }] } // 弹射物保护 3
        ]
      },
      {
        物品ID: "deeperdarker:warden_helmet", 物品权重: 1, 附魔方案列表: [ // 监守者头盔
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }] } // 保护 3
        ]
      }
    ],
    胸甲: [
      {
        物品ID: "minecraft:diamond_chestplate", 物品权重: 2, 附魔方案列表: [ // 钻石胸甲
          { 选择权重: 7, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }] }, // 保护 2
          { 选择权重: 3, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 1 }] } // 保护 3, 耐久 1
        ]
      },
      {
        物品ID: "l2complements:poseidite_chestplate", 物品权重: 1, 附魔方案列表: [ // 海王胸甲
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: { 最小等级: 2, 最大等级: 3 } }] } // 保护 2-3
        ]
      },
      {
        物品ID: "goety:dark_chestplate", 物品权重: 1, 附魔方案列表: [ // 黑暗胸甲
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }] } // 保护 2
        ]
      },
      {
        物品ID: "deeperdarker:warden_chestplate", 物品权重: 1, 附魔方案列表: [ // 监守者胸甲
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }] } // 保护 3
        ]
      }
    ],
    裤衩: [
      {
        物品ID: "minecraft:diamond_leggings", 物品权重: 2, 附魔方案列表: [ // 钻石护腿
          { 选择权重: 7, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }] }, // 保护 2
          { 选择权重: 3, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 1 }] } // 保护 3, 耐久 1
        ]
      },
      {
        物品ID: "l2complements:poseidite_leggings", 物品权重: 1, 附魔方案列表: [ // 海王护腿
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: { 最小等级: 2, 最大等级: 3 } }] } // 保护 2-3
        ]
      },
      {
        物品ID: "goety:dark_leggings", 物品权重: 1, 附魔方案列表: [ // 黑暗护腿
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }] } // 保护 2
        ]
      },
      {
        物品ID: "deeperdarker:warden_leggings", 物品权重: 1, 附魔方案列表: [ // 监守者护腿
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }] } // 保护 3
        ]
      }
    ],
    靴子: [
      {
        物品ID: "minecraft:diamond_boots", 物品权重: 2, 附魔方案列表: [ // 钻石靴子
          { 选择权重: 7, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }, { 附魔ID: "minecraft:feather_falling", 附魔等级: 2 }] }, // 保护 2, 摔落保护 2
          { 选择权重: 3, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }, { 附魔ID: "minecraft:feather_falling", 附魔等级: 3 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 1 }] } // 保护 3, 摔落保护 3, 耐久 1
        ]
      },
      {
        物品ID: "l2complements:poseidite_boots", 物品权重: 1, 附魔方案列表: [ // 海王靴子
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: { 最小等级: 2, 最大等级: 3 } }, { 附魔ID: "minecraft:depth_strider", 附魔等级: 1 }] } // 保护 2-3, 深海探索者 1
        ]
      },
      {
        物品ID: "goety:dark_boots", 物品权重: 1, 附魔方案列表: [ // 黑暗之靴
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 2 }, { 附魔ID: "minecraft:feather_falling", 附魔等级: 2 }] } // 保护 2, 摔落保护 2
        ]
      },
      {
        物品ID: "deeperdarker:warden_boots", 物品权重: 1, 附魔方案列表: [ // 监守者靴子
          { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 3 }, { 附魔ID: "minecraft:feather_falling", 附魔等级: 3 }] } // 保护 3, 摔落保护 3
        ]
      }
    ]
  },
  MYTHIC: {
    头盔: [
      {
        物品ID: "minecraft:netherite_helmet", 物品权重: 3, // 下界合金头盔
        附魔方案列表: [
          {
            选择权重: 10,
            附魔列表: [
              { 附魔ID: "minecraft:protection", 附魔等级: { 等级列表: [2, 4], 权重列表: [7, 3] } }, // 保护 2  或 4 
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:mending", 附魔等级: 1 }, // 经验修补 1
              { 附魔ID: "minecraft:respiration", 附魔等级: { 最小等级: 2, 最大等级: 3 } }, // 水下呼吸 2-3
            ]
          },
          {
            选择权重: 5,
            附魔列表: [
              { 附魔ID: "minecraft:fire_protection", 附魔等级: { 等级列表: [4, 5], 权重列表: [8, 2] } }, // 火焰保护 3 或 V 
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:thorns", 附魔等级: { 最小等级: 2, 最大等级: 3 } } // 荆棘 2-3
            ]
          },
          {
            选择权重: 2,
            附魔列表: [
              { 附魔ID: "minecraft:protection", 附魔等级: 3 }, // 保护 3
              { 附魔ID: "minecraft:fire_protection", 附魔等级: 4 }, // 火焰保护 3
              { 附魔ID: "minecraft:blast_protection", 附魔等级: 4 }, // 爆炸保护 3
              { 附魔ID: "minecraft:projectile_protection", 附魔等级: 4 }, // 弹射物保护 3
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:mending", 附魔等级: 1 } // 经验修补 1
            ]
          }
        ]
      },
      {
        物品ID: "twilightforest:fiery_helmet", 物品权重: 1, // 炽热头盔
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:fire_protection", 附魔等级: 3 }, // 火焰保护 V
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:protection", 附魔等级: 3 } // 保护 3
            ]
          }
        ]
      },
      {
        物品ID: "twilightforest:yeti_helmet", 物品权重: 1, // 雪怪头盔
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:protection", 附魔等级: 3 }, // 保护 V
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:thorns", 附魔等级: 3 } // 荆棘 3
            ]
          }
        ]
      }
    ],
    胸甲: [
      {
        物品ID: "minecraft:netherite_chestplate", 物品权重: 1, // 下界合金胸甲
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:protection", 附魔等级: 3 }, // 保护 V
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:mending", 附魔等级: 1 }, // 经验修补 1
              { 附魔ID: "minecraft:thorns", 附魔等级: 3 } // 荆棘 3
            ]
          }
        ]
      }
    ],
    裤衩: [
      {
        物品ID: "minecraft:netherite_leggings", 物品权重: 1, // 下界合金护腿
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:protection", 附魔等级: 3 }, // 保护 V
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
              { 附魔ID: "minecraft:mending", 附魔等级: 1 }, // 经验修补 1
              { 附魔ID: "minecraft:swift_sneak", 附魔等级: 3 } // 迅捷潜行 3
            ]
          }
        ]
      }
    ],
    靴子: [
      {
        物品ID: "minecraft:netherite_boots", 物品权重: 1, // 下界合金靴子
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:protection", 附魔等级: 5 }, // 保护 V
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
            ]
          }
        ]
      }
    ]
  }
};

let 难度近战武器池 = {
  EASY: [
    { 物品ID: "minecraft:wooden_sword", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 木剑
    { 物品ID: "minecraft:stone_sword", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] } // 石剑
  ],
  CLASSIC: [
    { 物品ID: "minecraft:stone_sword", 物品权重: 2, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }, // 石剑
    { 物品ID: "minecraft:iron_sword", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] } // 铁剑
  ],
  MASTER: [
    {
      物品ID: "minecraft:diamond_sword", 物品权重: 2, // 钻石剑
      附魔方案列表: [
        { 选择权重: 7, 附魔列表: [{ 附魔ID: "minecraft:sharpness", 附魔等级: { 最小等级: 2, 最大等级: 3 } }] }, // 锋利 2-3
        { 选择权重: 3, 附魔列表: [{ 附魔ID: "minecraft:sharpness", 附魔等级: 3 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 1 }] } // 锋利 3, 耐久 1
      ]
    },
    {
      物品ID: "minecraft:netherite_axe", 物品权重: 1, // 下界合金斧
      附魔方案列表: [
        { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:sharpness", 附魔等级: 1 }, { 附魔ID: "l2complements:sharp_blade", 附魔等级: 1 }] } // 锋利 1, 锐刃1
      ]
    }
  ],
  MYTHIC: [
    {
      物品ID: "minecraft:netherite_sword", 物品权重: 10, // 下界合金剑
      附魔方案列表: [
        {
          选择权重: 7,
          附魔列表: [
            { 附魔ID: "minecraft:sharpness", 附魔等级: 5 }, // 锋利 V
            { 附魔ID: "minecraft:looting", 附魔等级: { 等级列表: [2, 3], 权重列表: [4, 6] } }, // 抢夺 2 或 3
            { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
            { 附魔ID: "minecraft:mending", 附魔等级: 1 }, // 经验修补 1
            { 附魔ID: "minecraft:fire_aspect", 附魔等级: { 最小等级: 1, 最大等级: 2 } }, // 火焰附加 1-2
          ]
        },
        {
          选择权重: 3,
          附魔列表: [
            { 附魔ID: "minecraft:smite", 附魔等级: 5 }, // 亡灵杀手 V
            { 附魔ID: "minecraft:looting", 附魔等级: 3 }, // 抢夺 3
            { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
            { 附魔ID: "minecraft:mending", 附魔等级: 1 } // 经验修补 1
          ]
        },
        {
          选择权重: 1,
          附魔列表: [
            { 附魔ID: "minecraft:knockback", 附魔等级: { 最小等级: 2, 最大等级: 3 } }, // 击退 2-3
            { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
            { 附魔ID: "minecraft:mending", 附魔等级: 1 } // 经验修补 1
          ]
        }
      ]
    },
    {
      物品ID: "minecraft:netherite_axe", 物品权重: 5, // 下界合金斧
      基础NBT数据: { "HideFlags": 1 }, // 隐藏附魔
      附魔方案列表: [
        {
          选择权重: 8,
          附魔列表: [
            { 附魔ID: "minecraft:sharpness", 附魔等级: { 最小等级: 4, 最大等级: 5 } }, // 锋利 3-V
            { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, // 耐久 3
            { 附魔ID: "l2complements:sharp_blade", 附魔等级: { 最小等级: 2, 最大等级: 3 } }, // 锐刃 2-3
            { 附魔ID: "minecraft:efficiency", 附魔等级: 5 } // 效率 V
          ]
        },
        {
          选择权重: 2,
          附魔列表: [
            { 附魔ID: "minecraft:sharpness", 附魔等级: 3 }, // 锋利 3
            { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 } // 耐久 3
          ]
        }
      ]
    }
  ]
};

let 难度远程武器池 = {
  EASY: [
    { 物品ID: "minecraft:bow", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:power", 附魔等级: 1 }] }] } // 弓, 力量 1
  ],
  CLASSIC: [
    { 物品ID: "minecraft:bow", 物品权重: 2, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:power", 附魔等级: { 最小等级: 1, 最大等级: 2 } }] }] }, // 弓, 力量 1-2
    { 物品ID: "minecraft:crossbow", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:quick_charge", 附魔等级: 1 }] }] } // 弩, 快速装填 1
  ],
  MASTER: [
    {
      物品ID: "minecraft:bow", 物品权重: 2, 附魔方案列表: [ // 弓
        { 选择权重: 6, 附魔列表: [{ 附魔ID: "minecraft:power", 附魔等级: 3 }, { 附魔ID: "minecraft:punch", 附魔等级: 1 }] }, // 力量 3, 冲击 1
        { 选择权重: 4, 附魔列表: [{ 附魔ID: "minecraft:power", 附魔等级: 4 }, { 附魔ID: "minecraft:punch", 附魔等级: 2 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 1 }] } // 力量 3, 冲击 2, 耐久 1
      ]
    },
    {
      物品ID: "minecraft:crossbow", 物品权重: 1, 附魔方案列表: [ // 弩
        { 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:quick_charge", 附魔等级: 3 }, { 附魔ID: "minecraft:piercing", 附魔等级: 2 }, { 附魔ID: "minecraft:multishot", 附魔等级: 1 }] } // 快速装填 3, 穿透 2, 多重射击 1
      ]
    }
  ],
};

let 生物影响白名单 = {
  "quark:foxhound": { // 猎狐犬
    生命: 1, 速度: 1.2, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 5.0, 伤害: 1, 
  },
  "minecraft:zombie": { // 僵尸
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1.0, 武器类型: "近战", 名称: ["僵尸将军","僵尸骑士","僵尸武士"],
    生命: 1, 速度: 0.95, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 5.0, 伤害: 1,
  },
  "endermanoverhaul:spirit": { // 灵体
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:sludge": { // 淤泥怪
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:scarab": { // 圣甲虫
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:sculk_centipede": { // 幽匿蜈蚣
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:sculk_leech": { // 幽匿水蛭
    生命: 0.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:sculk_snapper": { // 幽匿啃啮兽
    生命: 1.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:the_watcher": { // 观测者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:draugr": { // 再行魂尸
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:deepling": { // 渊灵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:endermaptera": { // 末影甲虫
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:stable_ice_core": { // 稳定冰核
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:swarm_spider": { // 群聚蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:towerwood_borer": { // 塔木蛀虫
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:troll": { // 巨魔
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:unstable_ice_core": { // 不稳定冰核
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:upper_goblin_knight": { // 哥布林骑士（上层）
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:winter_wolf": { // 冬狼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:wraith": { // 幽灵
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:yeti": { // 雪怪
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "touhou_little_maid:fairy": { // 妖精女仆 
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1.1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:mist_wolf": { // 迷雾狼
    生命: 1.1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:pinch_beetle": { // 巨钳甲虫
    生命: 1.1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:redcap": { // 红帽
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:redcap_sapper": { // 红帽工兵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:skeleton_druid": { // 骷髅德鲁伊
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:slime_beetle": { // 黏液甲虫
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:snow_guardian": { // 冰雪守卫
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:blockchain_goblin": { // 链锤哥布林
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:carminite_broodling": { // 砷铅铁寄生虫
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:carminite_ghastguard": { // 高塔守卫
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:carminite_ghastling": { // 砷铅铁恶魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:carminite_golem": { // 砷铅铁傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:death_tome": { // 死灵书
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:fire_beetle": { // 喷火甲虫
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:harbinger_cube": { // 噩兆立方
    生命: 2.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:hedge_spider": { // 树篱蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:helmet_crab": { // 寄居蟹
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:hostile_wolf": { // 恶狼
    生命: 1.1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:ice_crystal": { // 冰晶
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:king_spider": { // 国王蜘蛛
    生命: 2.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:kobold": { // 狗头人
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 
    生命: 0.6, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:lower_goblin_knight": { // 哥布林骑士（下层）
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:maze_slime": { // 迷宫史莱姆
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:minotaur": { // 牛头人
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 2.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:adherent": { // 信徒
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "alexsmobs:soul_vulture": { // 灵魂秃鹫
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "alexsmobs:rocky_roller": { // 岩磙兽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "alexsmobs:guster": { // 沙风怪
    生命: 0.8, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "alexsmobs:straddler": { // 跨座兽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "aquamirae:pillagers_patrol": { // 掠夺者巡逻队员
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "aquamirae:tortured_soul": { // 被折磨的灵魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "aquamirae:eel": { // 鳗鱼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:rumia": { // 露米娅
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 名字: ["露米娅"],
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:cirno": { // 琪露诺
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:surrendered": { // 亡骨役奴
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthana_follower_raptor": { // 乌姆塔纳猛禽追随者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthana_follower_player": { // 乌姆塔纳追随者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthana_crane_player": { // 乌姆塔纳食人鹤追随者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthana": { // 乌姆塔纳族人
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthana_raptor": { // 乌姆塔纳猛禽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthana_crane": { // 乌姆塔纳食人鹤
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:grottol": { // 岩壳
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:naga": { // 飞蛇 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endertrigon:baby_ender_dragon": { // 末影龙宝宝
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 名字: ["末影龙宝宝"],
    生命: 5.0, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:foliaath": { // 巨噬叶
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:baby_foliaath": { // 幼年巨噬叶
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:carrion_maggot": { // 腐肉蛆虫
    生命: 0.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:carrion_fly": { // 腐肉蝇
    生命: 0.6, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:snapper": { // 黑鲷
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:haunt": { // 墓灵
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:redstone_cube": { // 红石方块
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:haunted_skull": { // 缠魂头骨
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:ravaged": { // 蹂躏者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:ripper": { // 开膛兽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:trampler": { // 践踏者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:silverfish": { // 蠹虫
    生命: 0.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:endermite": { // 末影螨
    生命: 0.8, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:slime": { // 史莱姆
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:crypt_slime": { // 墓穴史莱姆
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:vampire_bat": { // 吸血蝙蝠
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:black_wolf": { // 黑狼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:hostile_black_wolf": { // 敌对黑狼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:skeleton_wolf": { // 骷髅狼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  // "goety:hellhound": {}, // 地狱犬（无法召唤）
  "goety:twilight_goat": { // 暮光山羊
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:spider": { // 蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:icy_spider": { // 冰蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:bone_spider": { // 骨蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:wartling": { // 疣蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:zombie_villager": { // 僵尸村民
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:drowned": { // 溺尸
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "none",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:husk": { // 尸壳
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:reaper": { // 收割者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:maverick": { // 叛逆者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:witch": { // 女巫
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1.50, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:heretic": { // 异教徒
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:wraith": { // 幽灵
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:border_wraith": { // 边境幽灵
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:muck_wraith": { // 淤泥幽灵
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:skeleton": { // 骷髅
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1,  },
  "minecraft:stray": { // 流浪者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:vex": { // 恼鬼
    武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:irk": { // 怒鬼
    武器概率: 1, 武器类型: "近战",
    生命: 1.1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:pillager": { // 掠夺者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:skeleton_pillager": { // 骷髅掠夺者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:piglin": { // 猪灵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战", 名称: ["忘本猪"],
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:zombified_piglin": { // 僵尸猪灵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:mini_ghast": { // 迷你恶魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:ghast": { // 恶魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:malghast": { // 凶魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  // 小怪
  "hmag:zombie_girl": { // 僵尸娘
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:husk_girl": { // 尸壳娘
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:drowned_girl": { // 溺尸娘
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:skeleton_girl": { // 骷髅娘
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:wither_skeleton_girl": { // 凋零骷髅娘
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:stray_girl": { // 流浪者娘
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:creeper_girl": { // 苦力怕娘
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:ghost": { // 鬼魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:wither_ghost": { // 凋零鬼魂
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:kobold": { // 狗头人
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:lich": { // 小巫妖
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1.8, 速度: 1.1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:ogre": { // 食人魔
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:melty_monster": { // 岩浆娘
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:spider_nest": { // 蜘蛛巢穴
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:cursed_doll": { // 诅咒玩偶
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1.1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:jack_frost": { // 冰霜女巫
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:hornet": { // 蜜蜂娘
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:dullahan": { // 无头骑士娘
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:banshee": { // 报丧女妖
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1.1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:alraune": { // 花精灵
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:catoblepas": { // 卡托布莱帕斯
    生命: 1.2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:scorpion": { // 沙漠蝎
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:kasha": { // 焰猫妖
    生命: 1, 速度: 1.1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:dogu": { // 土偶
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:ghastly_seeker": { // 恶魂探索者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:redcap": { // 红帽地精
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:slime_girl": { // 史莱姆娘
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:magical_slime": { // 魔法史莱姆
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:monolith": { // 独石柱
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:crimson_slaughterer": { // 绯红屠戮者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:dyssomnia": { // 幻骨蝠
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:snow_canine": { // 雪犬娘
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:harpy": { // 鹰身女妖
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:savagefang": { // 野蛮獠牙
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:fortress_keeper": { // 堡垒守护者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:necrotic_reaper": { // 死灵潜行者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:dodomeki": { // 百目鬼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:imp": { // 小恶魔
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:glaryad": { // 怒目树妖
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:jiangshi": { // 跳尸
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:giant_mummy": { // 巨型木乃伊
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:nightwalker": { // 夜行者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "hmag:swamper": { // 沼泽怪
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:pyromancer": { // 炽焰术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:cryomancer": { // 冰霜术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 名称: ["冰豆腐砖"],
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:necromancer": { // 亡灵术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:archevoker": { // 高位唤魔者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:citadel_keeper": { // 远古骑士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:apothecarist": { // 药剂师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:cultist": { // 邪教徒
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:shattered": { // 破碎者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:shriek_worm": { // 尖啸匿蠕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "quark:wraith": { // 游魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:elite_draugr": { // 精英魂石
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:creeper": { // 苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:web_spider": { // 织网蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:jungle_creeper": { // 丛林苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:bamboo_creeper": { // 竹林苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:desert_creeper": { // 沙漠苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:badlands_creeper": { // 恶地苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:hills_creeper": { // 山丘苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:savannah_creeper": { // 热带草原苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:swamp_creeper": { // 沼泽苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:dripstone_creeper": { // 滴水石苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:cave_creeper": { // 洞穴苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:dark_oak_creeper": { // 黑橡木苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:spruce_creeper": { // 云杉苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:beach_creeper": { // 海滩苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:snowy_creeper": { // 雪地苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "creeperoverhaul:ocean_creeper": { // 海洋苦力怕
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "aquamirae:maw": { // 深渊巨口
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  //alexsmobs:farseer 瞻远者
  "alexsmobs:murmur": { // 轻语灵
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:cave_spider": { // 洞穴蜘蛛
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:phantom": { // 幻翼
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:blaze": { // 烈焰人
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:wildfire": { // 野火
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:guardian": { // 守卫者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:magma_cube": { // 岩浆怪
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:hoglin": { // 疣猪兽
    生命: 1.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:zoglin": { // 僵尸疣猪兽
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:piglin_brute": { // 猪灵蛮兵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:vindicator": { // 卫道士
    头盔: 0, 胸甲: 0, 裤衩: 0, 靴子: 0,
    生命: 1.2, 速度: 1, 追踪: 1, 攻速: 1, 伤害: 1, 武器概率: 1,
  },
  "goety:zombie_vindicator": { // 僵尸卫道士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1.3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:crusher": { // 粉碎者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:provoker": { // 挑衅者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:necromancer": { // 死灵法师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:basher": { // 猛击者
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:sorcerer": { // 不详术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:arch3ist": { // 档案员
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:inquisitor": { // 裁决者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:marauder": { // 掳掠者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:alchemist": { // 炼金术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",     
    生命: 3.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:firecaller": { // 唤火者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:illusioner": { // 幻术师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "远程",
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:evoker": { // 唤魔者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:bound_evoker": { // 被绑定的唤魔者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:bound_iceologer": { // 被绑定的冰法师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:warlock": { // 术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:shulker": { // 潜影贝
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:enderman": { // 末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:badlands_enderman": { // 恶地末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:cave_enderman": { // 洞穴末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:crimson_forest_enderman": { // 绯红森林末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:dark_oak_enderman": { // 黑森林末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:desert_enderman": { // 沙漠末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:end_enderman": { // 末地末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:end_islands_enderman": { // 末地岛屿末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:flower_fields_enderman": { // 花田末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:ice_spikes_enderman": { // 冰刺平原末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:nether_wastes_enderman": { // 下界荒地末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:coral_enderman": { // 珊瑚末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:savanna_enderman": { // 热带草原末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:snowy_enderman": { // 雪地末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:soulsand_valley_enderman": { // 灵魂沙谷末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:swamp_enderman": { // 沼泽末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:warped_forest_enderman": { // 诡异森林末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "endermanoverhaul:windswept_hills_enderman": { // 峭壁末影人
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:haunted_armor": { // 缠魂甲胄
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:damned": { // 狱魂
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "quark:forgotten": { // 遗忘者
    生命: 3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:deepling_angler": { // 渊灵垂钓者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:deepling_brute": { // 渊灵蛮兵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:deepling_priest": { // 渊灵祭司
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:deepling_warlock": { // 渊灵术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:coral_golem": { // 珊瑚傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:coralssus": { // 珊瑚巨兽
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "deeperdarker:stalker": { // 潜行者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 10, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:giant": { // 巨人
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:giant_miner": { // 巨人矿工
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:ender_golem": { // 末影傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 10, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  // 进阶
  "hmag:ender_executor": { // 末影处刑者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:shrine_maiden": { // 博丽灵梦
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:youkai": { // 妖怪
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:fairy": { // 妖精
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:yukari": { // 八云紫
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:kochiya_sanae": { // 东风谷早苗
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:kirisame_marisa": { // 雾雨魔理沙
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:komeiji_koishi": { // 古明地恋
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:remilia_scarlet": { // 蕾米莉亚·斯卡雷特
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:mystia_lorelei": { // 米斯蒂娅·萝蕾拉
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:sunny_milk": { // 桑尼米尔克
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:luna_child": { // 露娜查尔德
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "youkaishomecoming:star_sapphire": { // 斯塔萨菲娅
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:royal_draugr": { // 皇家魂尸
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 2.5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:armored_giant": { // 武装巨人
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:wither_skeleton": { // 凋灵骷髅
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:whisperer": { // 唤滕者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:wavewhisperer": { // 唤浪者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:sorcerer": { // 巫师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:envioker": { // 恶妒者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:tormentor": { // 折磨
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:inquillager": { // 巡查官
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:conquillager": { // 征服者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器概率: 1, 武器类型: "近战",
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:piker": { // 长矛兵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:storm_caster": { // 风暴术士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:cryologer": { // 泣法师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:preacher": { // 传教士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:minister": { // 牧师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 8, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:necromancer": { // 死灵法师 
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:cairn_necromancer": { // 坟墓死灵法师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:ally_trampler": { // 盟友践踏者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:ravager": { // 劫掠兽 (goety村民转化)
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:armored_ravager": { // 劫掠兽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:zombie_ravager": { // 僵尸劫掠兽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:ravager": { // 劫掠兽 (原版) 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:black_beast": { // 暗兽
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:leapleaf": { // 腾跃之叶
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:ice_golem": { // 冰傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:squall_golem": { // 暴风傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:redstone_golem": { // 红石傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 8, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:hostile_redstone_golem": { // 敌对红石傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 10, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:grave_golem": { // 坟墓傀儡
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:elder_guardian": { // 远古守卫者
    头盔: 1.0, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:ancient_ancient_remnant": { // 上古遗魂
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 25, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:wadjet": { // 蛇形妖骸
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:ignited_revenant": { // 燃魂
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:ignited_berserker": { // 炽燃狂魂
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:the_prowler": { // 徘徊者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:redstone_monstrosity": { // 红石巨兽
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 2, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:hostile_redstone_monstrosity": { // 敌对红石巨兽
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:aptrgangr": { // 冥行武弁
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:brood_mother": { // 育母蜘蛛
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:old_netherite_monstrosity": { // 远古下界合金巨怪
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:obsidian_monolith": { // 黑曜石巨石
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 10, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:amethyst_crab": { // 紫水晶巨蟹
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  // 精英
  "alexsmobs:warped_mosco": { // 诡异蚊鬼
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 10, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:wight": { // 孤魂尸鬼
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:inferno": { // 狱焰
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:alpha_yeti": { // 雪怪首领
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 10, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:hydra": { // 九头蛇
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 25, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:knight_phantom": { // 幻影骑士
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 45, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:lich": { // 巫妖
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:minoshroom": { // 米诺菇
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:naga": { // 娜迦 
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 7, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:snow_queen": { // 冰雪女王
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 30, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "twilightforest:ur_ghast": { // 暮初恶魂
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 16, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "irons_spellbooks:dead_king": { // 死者之王
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 12, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "bosses_of_mass_destruction:void_blossom": { // 虚空之花
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:wither": { // 凋灵
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 8, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "cataclysm:kobolediator": { // 骷髅狗头人将军
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 1, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "minecraft:warden": { // 监守者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "illagerinvasion:invoker": { // 祈灵师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:skull_lord": { // 骷髅领主
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 2.3, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:bone_lord": { // 骨骼领主
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "goety:wither_necromancer": { // 凋零死灵法师
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:ferrous_wroughtnaut": { // 钢铁守护者
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 名字: ["肛腚守护者"],
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "mowziesmobs:umvuthi": { // 乌姆塔纳，太阳鸟
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1,
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "bosses_of_mass_destruction:lich": { // 暗夜巫妖
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 15, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  },
  "bosses_of_mass_destruction:gauntlet": { // 下届铁掌
    头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 
    生命: 5, 速度: 1, 护甲: 1, 韧性: 1, 追踪: 1, 攻速: 1, 伤害: 1
  }
};

let 生物定制配置 = {
  "alexsmobs:void_worm": { // 虚空蠕虫
    属性列表: { 生命: 10, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 2 },名字:["虚空裁决者"],
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "goety:apostle": {
    属性列表: { 生命: 50, 速度: 1.2, 护甲: 1.2, 韧性: 1.1, 追踪: 1.2, 攻速: 1.5, 伤害: 1.2,  }, 
    装备池引用: { 头盔: "腾炎头盔", 胸甲: "腾炎胸甲", 裤衩: "腾炎裤衩", 靴子: "腾炎靴子", 武器: "使徒弓"
    },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
    武器类型: "远程"
  },
  "mowziesmobs:frostmaw": { // 霜冻巨兽
    属性列表: { 生命: 5, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
  },
  "aquamirae:maze_mother": { // 迷宫之母
    属性列表: { 生命: 3, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
  },
  "aquamirae:captain_cornelia": { // 船长科妮莉亚亡灵
    属性列表: { 生命: 20, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
  },
  "cataclysm:ender_guardian": { // 末影守卫者
    属性列表: { 生命: 8, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:netherite_monstrosity": { // 下界合金巨兽
    属性列表: { 生命: 10, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:the_harbinger": { // 先驱者
    属性列表: { 生命: 10, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },名字: ["疯狂的doro"],
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:the_leviathan": { // 利维坦
    属性列表: { 生命: 8, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 3 }, 名字: ["深渊之主-水煮鱼配虾饺"],
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:ancient_remnant": { // 远古遗魂
    属性列表: { 生命: 15, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 2 },名字:["沙漠坟地大总管"],
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:maledictus": { // 咒翼灵骸
    属性列表: { 生命: 18, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 3.75 }, 名字: ["传奇坠机王：白仄黎","白仄黎 man !"],
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:ignis": { // 焰魔
    属性列表: { 生命: 15, 速度: 1.2, 护甲: 1.5, 韧性: 1.5, 追踪: 1, 攻速: 1, 伤害: 3.5 },名字:["永恒之焰-"],
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "cataclysm:scylla": { // 斯库拉
    属性列表: { 生命: 15, 速度: 1.2, 护甲: 1.5, 韧性: 1.5, 追踪: 1, 攻速: 1, 伤害: 3.5 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "goety:vizier": { // 宰相
    属性列表: { 生命: 20, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "goety:vizier_clone": { // 宰相之影
    属性列表: { 生命: 15, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "bosses_of_mass_destruction:obsidilith": { // 黑曜石柱
    属性列表: { 生命: 8, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 2.75 },
    装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
    装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
  "minecraft:ender_dragon": { // 末影龙
   属性列表: { 生命: 30, 速度: 1, 护甲: 0.5, 韧性: 0.5, 追踪: 1, 攻速: 1, 伤害: 1.25 }, 名字: ["龙娘:敖兴"],
   装备池引用: { 头盔: "", 胸甲: "", 裤衩: "", 靴子: "", 武器: "" },
   装备基础概率: { 头盔: 1, 胸甲: 1, 裤衩: 1, 靴子: 1, 武器: 1 },
  },
};

let 不使用修改器生物列表 = {
  // "minecraft:creeper": {
  //     生命: 1.5, 速度: 1.1,
  //     头盔: 0.5, 武器类型: "无"
  // },
};

let 定制实体护甲池 = {
  EASY: {
    "简易皮革头盔池": [{ 物品ID: "minecraft:leather_helmet", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }]
  },
  CLASSIC: {
    "铁木头盔池": [{ 物品ID: "twilightforest:ironwood_helmet", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:protection", 附魔等级: 1 }] }] }]
  },
  MYTHIC: {
    "腾炎头盔": [
      {
        物品ID: "cataclysm:ignitium_helmet", 物品权重: 1,
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:fire_protection", 附魔等级: { 最小等级: 4, 最大等级: 5 } },
              { 附魔ID: "minecraft:protection", 附魔等级: { 最小等级: 3, 最大等级: 4 } },
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 },
              { 附魔ID: "minecraft:thorns", 附魔等级: { 最小等级: 2, 最大等级: 3 } }
            ]
          }
        ]
      }
    ],
    "腾炎胸甲": [{ 物品ID: "cataclysm:ignitium_chestplate", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:fire_protection", 附魔等级: 5 }, { 附魔ID: "minecraft:protection", 附魔等级: 4 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }] }] }],
    "腾炎裤衩": [{ 物品ID: "cataclysm:ignitium_leggings", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:fire_protection", 附魔等级: 5 }, { 附魔ID: "minecraft:protection", 附魔等级: 4 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }] }] }],
    "腾炎靴子": [{ 物品ID: "cataclysm:ignitium_boots", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [{ 附魔ID: "minecraft:fire_protection", 附魔等级: 5 }, { 附魔ID: "minecraft:feather_falling", 附魔等级: 4 }, { 附魔ID: "minecraft:protection", 附魔等级: 4 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }] }] }]
  }
};

let 定制实体武器池 = {
  EASY: {
    "新手木剑池": [{ 物品ID: "minecraft:wooden_sword", 物品权重: 1, 附魔方案列表: [{ 选择权重: 1, 附魔列表: [] }] }]
  },
  CLASSIC: {
    "使徒弓": [
      {
        物品ID: "minecraft:bow", 物品权重: 1,
        附魔方案列表: [
          {
            选择权重: 8,
            附魔列表: [
              { 附魔ID: "minecraft:power", 附魔等级: 7 }, 
              { 附魔ID: "minecraft:punch", 附魔等级: 3 },
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 2 },
            ]
          },
          {
            选择权重: 2,
            附魔列表: [
              { 附魔ID: "minecraft:power", 附魔等级: 9 },
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 2 },
              { 附魔ID: "minecraft:punch", 附魔等级: 2 }
            ]
          }
        ]
      }
    ]
  },
  MYTHIC: {
    "使徒弓": [
      {
        物品ID: "minecraft:bow", 物品权重: 1,
        附魔方案列表: [
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:power", 附魔等级: 10 }, { 附魔ID: "minecraft:punch", 附魔等级: 5 },
              { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, { 附魔ID: "minecraft:flame", 附魔等级: 1 }
            ]
          },
          {
            选择权重: 1,
            附魔列表: [
              { 附魔ID: "minecraft:power", 附魔等级: { 最小等级: 5, 最大等级: 15 } }, { 附魔ID: "minecraft:infinity", 附魔等级: 1 },
              { 附魔ID: "minecraft:flame", 附魔等级: 1 }, { 附魔ID: "minecraft:unbreaking", 附魔等级: 3 }, { 附魔ID: "minecraft:punch", 附魔等级: 3 }
            ]
          }
        ]
      }
    ],
  }
};